#!/bin/bash

echo Certificati installati:
for i in /etc/letsencrypt/live/*/cert.pem; do 
    echo "in $i":
    MAIN=$(openssl x509 -text -noout < $i|grep Subject:|cut -d= -f2)
    echo Main CN: $MAIN
    ALT=$(openssl x509 -text -noout < $i | \
      sed -n -r '/X509v3 Subject Alternative Name:/,+1p' \
       | egrep -v '(Subject Public Key Info:|X509v3 Subject)' \
       | tr -d ',:DNS')
    echo Alternate: 
    for j in $ALT; do
    	echo - $j
    done
done

